<?php

defined('MBQ_IN_IT') or exit;

MbqMain::$oClk->includeClass('MbqBaseWrEtPc');

/**
 * private conversation write class
 */
Class MbqWrEtPc extends MbqBaseWrEtPc {

    public function __construct() {
    }

    /**
     * add private conversation
     *
     * @param  Object  $oMbqEtPc
     */
    public function addMbqEtPc($oMbqEtPc) {
        try {
            // $cleaner = vB::getCleaner();
            $convContent = MbqMain::$oMbqCm->exttConvertAppAttBbcodeToNativeCode($oMbqEtPc->convContent->oriValue);     //attention!!!
            $result = vB_Api::instance('content_privatemessage')->add(
                array(
                    'msgRecipients' => implode(',', $oMbqEtPc->userNames->oriValue),
                    'title' => mobiquo_encode($oMbqEtPc->convTitle->oriValue, 'to_local'),
                    // 'rawtext' => htmlspecialchars($cleaner->clean($oMbqEtPc->convContent->oriValue) ,ENT_NOQUOTES ),
                    'rawtext' => mobiquo_encode($convContent, 'to_local')
                )
            );

            if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                $oMbqEtPc->convId->setOriValue($result);
                $resultThread = vB_Api::instanceInternal('content_privatemessage')->getMessage($oMbqEtPc->convId->oriValue);
                $oMbqEtPc->firstMsgId->setOriValue($resultThread['message']['nodeid']);
            } else {
                MbqError::alert('', mobiquo_encode(MbqMain::$oMbqAppEnv->exttGetErrorMessage($result)), '', MBQ_ERR_APP);
            }
        } catch (Exception $e) {
            MbqError::alert('', "Can not save!Content too short or please post later.", '', MBQ_ERR_APP);
        }
        return $oMbqEtPc;
    }
    public function inviteParticipant($oMbqEtPcInviteParticipant) {

    }
    /**
     * delete conversation
     *
     * @param  Object  $oMbqEtPc
     * @param  Integer  $mode
     */
    public function deleteConversation($oMbqEtPc, $mode) {
        if ($mode ==1 || $mode == 2) {
            try {
                if($mode==2){
                    $result = vB_Api::instance('content_privatemessage')->deleteMessages($oMbqEtPc->convId->oriValue);
                }
                else{
                    $result = vB_Api::instance('content_privatemessage')->toTrashcan($oMbqEtPc->convId->oriValue);
                }
                if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                    if (!$result) {
                        MbqError::alert('', "Can not delete conversation!", '', MBQ_ERR_APP);
                    }
                } else {
                    MbqError::alert('', "Can not delete conversation!", '', MBQ_ERR_APP);
                }
            } catch (Exception $e) {
                MbqError::alert('', "Can not delete conversation!", '', MBQ_ERR_APP);
            }
        } else {
            MbqError::alert('', "Need valid mode id!", '', MBQ_ERR_APP);
        }
    }
   public function markPcRead($oMbqEtPc)
   {

   }
}
