<?php

defined('MBQ_IN_IT') or exit;

MbqMain::$oClk->includeClass('MbqBaseWrEtForumTopic');

/**
 * forum topic write class
 */
Class MbqWrEtForumTopic extends MbqBaseWrEtForumTopic {

    public function __construct() {
    }

    /**
     * add forum topic view num
     *
     * @param  Mixed  $var($oMbqEtForumTopic or $objsMbqEtForumTopic)
     */
    public function addForumTopicViewNum($oMbqEtForumTopic) {
         //do nothing
    }

    /**
     * mark forum topic read
     *
     * @param  Mixed  $var($oMbqEtForumTopic or $objsMbqEtForumTopic)
     * @param  Array  $mbqOpt
     * $mbqOpt['case'] = 'markAllAsRead' means mark all my unread topics as read
     */
    public function markForumTopicRead($oMbqEtForumTopic) {
        $mark = vB_Api::instance('node')->markRead($oMbqEtForumTopic->topicId->oriValue);
        if($mark === null || !empty($mark['errors'])) {
            MbqError::alert('', "Mark topic failed!", '', MBQ_ERR_APP);
        }
        return true;
    }

    /**
     * reset forum topic subscription
     *
     * @param  Mixed  $var($oMbqEtForumTopic or $objsMbqEtForumTopic)
     */
    public function resetForumTopicSubscription($oMbqEtForumTopic) {
         //do nothing
    }
    /**
     * subscribe topic
     */
    public function subscribeTopic($oMbqEtForumTopic,$receiveEmail) {
        $result = vB_Api::instance('follow')->add($oMbqEtForumTopic->topicId->oriValue, vB_Api_Follow::FOLLOWTYPE_CONTENT);

        if (empty($result) || !empty($result['errors'])) {
            MbqError::alert('', "Can not subscribe to this topic.", '', MBQ_ERR_APP);
        }

        return true;
    }

    /**
     * unsubscribe topic
     */
    public function unsubscribeTopic($oMbqEtForumTopic) {
        $result = vB_Api::instance('follow')->delete($oMbqEtForumTopic->topicId->oriValue, vB_Api_Follow::FOLLOWTYPE_CONTENT);

        if (empty($result) || !empty($result['errors'])) {
            MbqError::alert('', "Can not subscribe to this topic.", '', MBQ_ERR_APP);
        }

        return true;
    }

    function getErrorFromResult($result){
        $error = vB_Library::instance('vb4_functions')->getErrorResponse($result);
        if(!empty($error)){
            $message = $error['response']['errormessage'];
            if($message=='maxchars_exceeded_x_title_y'){
                $vboptions = vB::getDatastore()->getValue('options');
                $titlemaxchars = $vboptions['titlemaxchars'];
                MbqError::alert('', "Maximum number of characters exceeded in the title. It cannot be more than $titlemaxchars characters.", '', MBQ_ERR_APP);
            }else if($message=='cannot_reply_to_redirect'){
                MbqError::alert('', "You cannot reply to a redirect. Please follow the redirect and add your content to the new location.", '', MBQ_ERR_APP);
            }else{
                MbqError::alert('', "Can not save!Content too short or please post later.", '', MBQ_ERR_APP);
            }
        }
        MbqError::alert('', "Can not save!Content too short or please post later.", '', MBQ_ERR_APP);
    }

    /**
     * add forum topic
     *
     * @param  Mixed  $oMbqEtForumTopic($oMbqEtForumTopic or $objsMbqEtForumTopic)
     */
    public function addMbqEtForumTopic($oMbqEtForumTopic) {

            $data['parentid'] = $oMbqEtForumTopic->forumId->oriValue;
            $data['title'] = $oMbqEtForumTopic->topicTitle->oriValue;
            $data['title'] = mobiquo_encode($data['title'], 'to_local');
            $data['rawtext'] = MbqMain::$oMbqCm->exttConvertAppAttBbcodeToNativeCode($oMbqEtForumTopic->topicContent->oriValue);     //attention!!!
            $data['rawtext'] = mobiquo_encode($data['rawtext'], 'to_local');
            $data['created'] = vB::getRequest()->getTimeNow();
            try {
                $result = vB_Api::instance('content_text')->add($data);
                if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                    $oMbqEtForumTopic->topicId->setOriValue($result);
                    //handle atts start,ref vB5_Frontend_Controller_CreateContent::index()
                    $attIds = $oMbqEtForumTopic->attachmentIdArray->oriValue;
                    if ($attIds) {
                        foreach ($attIds as $attId) {
                            $attData = array(
                                'filedataid' => $attId,
                                'filename' => 'ImageUploadedByTapatalk'.microtime(true).'.jpg'  //TODO:since app only support jpg file,now only use a jpg file name
                            );
                            try {
                                $resultAtt = vB_Api::instance('node')->addAttachment($oMbqEtForumTopic->topicId->oriValue, $attData);    //
                                if (MbqMain::$oMbqAppEnv->exttHasErrors($resultAtt)) {
                                    MbqError::alert('', "Can not save attachment info!", '', MBQ_ERR_APP);
                                }
                            } catch (Exception $e) {
                            	MbqError::alert('', "Can not save attachment info!", '', MBQ_ERR_APP);
                            }
                        }
                    }
                    //handle atts end
                } else {
                    $this->getErrorFromResult($result);
                }
                $oMbqRdEtForumTopic = MbqMain::$oClk->newObj('MbqRdEtForumTopic');
                vB_Api::instance('node')->markRead($oMbqEtForumTopic->topicId->oriValue);
                return $oMbqEtForumTopic;
            } catch (Exception $e) {
            	MbqError::alert('', "Can not save! Content too short or please post later.", '', MBQ_ERR_APP);
            }

    }

    /**
     * m_stick_topic
     */
    public function mStickTopic($oMbqEtForumTopic, $mode) {
        if($mode==1){
            $stick = vB_Api::instance('node')->setSticky(array($oMbqEtForumTopic->topicId->oriValue));
            if($stick === null || !empty($stick['errors'])) {
                 MbqError::alert('', "Stick topic failed!", '', MBQ_ERR_APP);
            }
        }else{
            $unstick = vB_Api::instance('node')->unsetSticky(array($oMbqEtForumTopic->topicId->oriValue));
            if($unstick === null || !empty($unstick['errors'])) {
                MbqError::alert('', "Unstick topic failed!", '', MBQ_ERR_APP);
            }
        }
        return true;

    }

    /**
     * m_close_topic
     */
    public function mCloseTopic($oMbqEtForumTopic, $mode) {
        if($mode==1){
            $unlock = vB_Api::instance('node')->openNode($oMbqEtForumTopic->topicId->oriValue);
            if ($unlock === null || !empty($unlock['errors'])) {
                 MbqError::alert('', "Reopen topic failed!", '', MBQ_ERR_APP);
            }
        }else{
            $lock = vB_Api::instance('node')->closeNode($oMbqEtForumTopic->topicId->oriValue);
            if($lock === null || !empty($lock['errors'])) {
                MbqError::alert('', "Close topic failed!", '', MBQ_ERR_APP);
            }
        }
        return true;
    }

    /**
     * m_delete_topic
     */
    public function mDeleteTopic($oMbqEtForumTopic, $mode, $reason) {
        ($mode == 2) ? $hard = true : $hard = false;
        $delete = vB_Api::instance('node')->deleteNodes(array($oMbqEtForumTopic->topicId->oriValue), $hard, $reason);
        if(empty($delete)) {
             MbqError::alert('', "Delete topic failed!", '', MBQ_ERR_APP);
        }
        return true;
    }

    /**
     * m_undelete_topic
     */
    public function mUndeleteTopic($oMbqEtForumTopic) {
        $delete = vB_Api::instance('node')->undeleteNodes(array($oMbqEtForumTopic->topicId->oriValue));
        if(empty($delete)) {
             MbqError::alert('', "Undelete topic failed!", '', MBQ_ERR_APP);
        }
        return true;
    }

    /**
     * m_undelete_topic
     */
    public function mMoveTopic($oMbqEtForumTopic, $oMbqEtForum, $redirect) {
        if(!$redirect) $redirect = array('redirect' => 'perm');
        else $redirect = array('redirect' => $redirect);
        $cleaner = vB::getCleaner();
        $threadids = $cleaner->clean($oMbqEtForumTopic->topicId->oriValue, vB_Cleaner::TYPE_STR);
        $destforumid = $cleaner->clean($oMbqEtForum->forumId->oriValue, vB_Cleaner::TYPE_UINT);
        $threadids = explode(',', $threadids);
        $threadids = array_map("trim", $threadids);
        if (empty($threadids)) {
            MbqError::alert('', "Need valid topic id!", '', MBQ_ERR_APP);
        }
        if (empty($destforumid)) {
            MbqError::alert('', "Need valid forum id!", '', MBQ_ERR_APP);
        }
        $moved = vB_Api::instance('node')->moveNodes($threadids, $destforumid, true, false, true, $redirect);
        if($moved === null || isset($moved['errors'])) {
             MbqError::alert('', "Move topic failed!", '', MBQ_ERR_APP);
        }
        return true;
    }

    /**
     * m_undelete_topic
     */
    public function mRenameTopic($oMbqEtForumTopic, $title) {
        $topic = array(
            'title' => $title
        );
        $result = vB_Api::instance('content_text')->update($oMbqEtForumTopic->topicId->oriValue, $topic);
        if(empty($result) || isset($moved['errors']) ){
             MbqError::alert('', "Rename topic failed!", '', MBQ_ERR_APP);
        }
        return true;
    }

    /**
     * m_approve_topic
     *
     * @param  Object  $oMbqEtForumTopic
     * @param  Integer  $mode
     */
    public function mApproveTopic($oMbqEtForumTopic, $mode) {

        if ($mode == 1) {
            $result = vB_Api::instance('node')->setApproved(array($oMbqEtForumTopic->topicId->oriValue), true);
        } elseif ($mode == 2) {
            $result = vB_Api::instance('node')->setApproved(array($oMbqEtForumTopic->topicId->oriValue), false);
        } else {
            MbqError::alert('', "Need valid mode!", '', MBQ_ERR_APP);
        }
        if ($result === null || isset($result['errors'])) {
            MbqError::alert('', vB_Library::instance('vb4_functions')->getErrorResponse($result), '', MBQ_ERR_APP);
        }
        return true;
    }

    /**
     * m_merge_topic
     */
    public function mMergeTopic($topicIdA, $topicIdB ,$redirect) {
        $result = vB_Api::instance('node')->mergeTopics(array($topicIdA->topicId->oriValue, $topicIdB->topicId->oriValue), $topicIdA->topicId->oriValue , array($redirect));
        if ($result === null || isset($result['errors'])) {
            MbqError::alert('', "Can not merge topic!", '', MBQ_ERR_APP);
        }
        return true;
    }
}
