<?php

defined('MBQ_IN_IT') or exit;

MbqMain::$oClk->includeClass('MbqBaseWrEtForumPost');

/**
 * forum post write class
 */
Class MbqWrEtForumPost extends MbqBaseWrEtForumPost {
    
    public function __construct() {
    }
    
    function getErrorFromResult($result){
        $error = vB_Library::instance('vb4_functions')->getErrorResponse($result);
        if(!empty($error)){
            $message = $error['response']['errormessage'];
            if($message=='maxchars_exceeded_x_title_y'){
                $vboptions = vB::getDatastore()->getValue('options');
                $titlemaxchars = $vboptions['titlemaxchars'];
                MbqError::alert('', "Maximum number of characters exceeded in the title. It cannot be more than $titlemaxchars characters.", '', MBQ_ERR_APP);
            }else if($message=='cannot_reply_to_redirect'){
                MbqError::alert('', "You cannot reply to a redirect. Please follow the redirect and add your content to the new location.", '', MBQ_ERR_APP);
            }else{
                MbqError::alert('', "Can not save!Content too short or please post later.", '', MBQ_ERR_APP);
            }
        }
        MbqError::alert('', "Can not save!Content too short or please post later.", '', MBQ_ERR_APP);
    }
    
    /**
     * add forum post
     *
     * @param  Mixed  $var($oMbqEtForumPost or $objsMbqEtForumPost)
     */
    public function addMbqEtForumPost($oMbqEtForumPost) {
    
            // $data['title'] = '(Untitled)';
            //$data['rawtext'] = $var->postContent->oriValue;
            $data['rawtext'] = MbqMain::$oMbqCm->exttConvertAppAttBbcodeToNativeCode($oMbqEtForumPost->postContent->oriValue);     //attention!!!
            $data['rawtext'] = mobiquo_encode($data['rawtext'], 'to_local');
            $data['parentid'] = $oMbqEtForumPost->topicId->oriValue;
            $data['created'] = vB::getRequest()->getTimeNow();
            $result = vB_Api::instance('content_text')->add($data);
            if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                $oMbqEtForumPost->postId->setOriValue($result);
                //handle atts start,ref vB5_Frontend_Controller_CreateContent::index()
                $attIds = $oMbqEtForumPost->attachmentIdArray->oriValue;
                if ($attIds) {
                    foreach ($attIds as $attId) {
                        $attData = array(
                            'filedataid' => $attId,
                            'filename' => 'ImageUploadedByTapatalk'.microtime(true).'.jpg'  //TODO:since app only support jpg file,now only use a jpg file name
                        );
                        try {
                            $resultAtt = vB_Api::instance('node')->addAttachment($oMbqEtForumPost->postId->oriValue, $attData);     //
                            if (MbqMain::$oMbqAppEnv->exttHasErrors($resultAtt)) {
                                MbqError::alert('', "Can not save attachment info!", '', MBQ_ERR_APP);
                            }
                        } catch (Exception $e) {
                        	MbqError::alert('', "Can not save attachment info!", '', MBQ_ERR_APP);
                        }
                    }
                }
                //handle atts end
            } else {
                $this->getErrorFromResult($result);
            }
            vB_Api::instance('node')->markRead($oMbqEtForumPost->topicId->oriValue);
            return $oMbqEtForumPost;
    }
    
    /**
     * modify forum post
     *
     * @param  Mixed  $var($oMbqEtForumPost or $objsMbqEtForumPost)
     */
    public function mdfMbqEtForumPost($oMbqEtForumPost, $mbqOp) {
        $data['title'] = $oMbqEtForumPost->postTitle->oriValue;
        $data['parentid'] = $oMbqEtForumPost->topicId->oriValue;
        //$data['rawtext'] = $oMbqEtForumPost->postContent->oriValue;
        $data['rawtext'] = MbqMain::$oMbqCm->exttConvertAppAttBbcodeToNativeCode($oMbqEtForumPost->postContent->oriValue);     //attention!!!
        $result = vB_Api::instance('content_text')->update($oMbqEtForumPost->postId->oriValue, $data);
        if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
        } else {
            MbqError::alert('', "Can not save!Content too short or please post later.", '', MBQ_ERR_APP);
        }
        return $oMbqEtForumPost;
    }
    
    
    /**
     * m_delete_post
     */
    public function mDeletePost($oMbqEtForumPost, $mode, $reason='') {
        ($mode == 2) ? $hard = true : $hard = false;
        $delete = vB_Api::instance('node')->deleteNodes($oMbqEtForumPost->postId->oriValue, $hard, $reason);
        if($delete === null || !$delete) {
            MbqError::alert('', "Delete post failed!", '', MBQ_ERR_APP);
        }
        return true;
    }
    
    /**
     * m_undelete_post
     */
    public function mUndeletePost($oMbqEtForumPost) {
        $delete = vB_Api::instance('node')->undeleteNodes($oMbqEtForumPost->postId->oriValue);
        if ($delete === null || !empty($delete['errors'])) {
            MbqError::alert('', "Undelete post failed!", '', MBQ_ERR_APP);
        }
        return true;
    }
  
    /**
     * m_undelete_post
     */
    public function mMovePost($oMbqEtForumPost, $oMbqEtForum, $oMbqEtForumTopic, $topicTitle = '') {

        $cleaner = vB::getCleaner();
        if(is_array($oMbqEtForumPost))
        {
            foreach($oMbqEtForumPost as $post)
            {
                $postids[] = $post->postId->oriValue;
            }
        }
        else
        {
            $postids = $cleaner->clean($oMbqEtForumPost->postId->oriValue, vB_Cleaner::TYPE_STR);
            $postids = explode(',', $postids);
            $postids = array_map("trim", $postids);
        }
        $title = $cleaner->clean($topicTitle, vB_Cleaner::TYPE_STR);
        $destforumid = $cleaner->clean($oMbqEtForum->forumId->oriValue, vB_Cleaner::TYPE_UINT);
     
        if (empty($postids)) {
            MbqError::alert('', "Need valid post id!", '', MBQ_ERR_APP);
        }
        if (empty($destforumid)) {
            MbqError::alert('', "Need valid forum id!", '', MBQ_ERR_APP);
        }
        $result = vB_Api::instance('node')->moveNodes($postids, $destforumid, true, $title);
        if ($result === null || isset($result['errors'])) {
            MbqError::alert('', vB_Library::instance('vb4_functions')->getErrorResponse($result), '', MBQ_ERR_APP);
        }
        return true;

    }
    
   
    
    /**
     * m_approve_post
     *
     * @param  Object  $oMbqEtForumPost
     * @param  Integer  $mode
     */
    public function mApprovePost($oMbqEtForumPost, $mode) {
        
        if ($mode == 1) {
            $result = vB_Api::instance('node')->setApproved(array($oMbqEtForumPost->postId->oriValue), true);
        } elseif ($mode == 2) {
            $result = vB_Api::instance('node')->setApproved(array($oMbqEtForumPost->postId->oriValue), false);
        } else {
            MbqError::alert('', "Need valid mode!", '', MBQ_ERR_APP);
        }
        if ($result === null || isset($result['errors'])) {
            MbqError::alert('', vB_Library::instance('vb4_functions')->getErrorResponse($result), '', MBQ_ERR_APP);
        }
        return true;
    }
    
    function getTextTopic($postIds){
        $nodes = vB_Library::instance('node')->getNodes($postIds);
        $text = array();
        foreach ($nodes as $node) $text[] = $node['rawtext'];
        return implode('<br>', $text);
    }
    
     /**
     * m_merge_post
     */
    public function mMergePost($postIds, $postId) {
        if(is_array($postIds)) $postIds[] = $postId;
        else $postIds = $postIds . ',' . $postId;
        if(!is_array($postIds)) $postIds = explode (',', $postIds);
        $oCurJUser = MbqMain::$oMbqAppEnv->currentUserInfo;
        $input = array(
            0 => array(
                'name' => 'text',
                'value' => $this->getTextTopic($postIds)
            ),
            1 => array(
                'name' => 'mergePosts',
                'value' => $postIds
            ),
            2 => array(
                'name' => 'destnodeid',
                'value' => $postIds[0],
            ),
            3 => array(
                'name' => 'destauthorid',
                'value' => $oCurJUser['userid'],
            ),
            4 => array(
                'name' => 'contenttype',
                'value' => 'text',
            )
        );
        
        $result = vB_Api::instance('node')->mergePosts($input);
        if ($result === null || isset($result['errors'])) {
            MbqError::alert('', 'Can not merge posts!', '', MBQ_ERR_APP);
        }
        return true;
    }

    public function likePost($oMbqEtForumPost) {
        $nodeId = $oMbqEtForumPost->postId->oriValue;
        $reputationApi = vB_Api::instanceInternal('reputation');
        $reputationApi->vote($nodeId);

    }

    public function unlikePost($oMbqEtForumPost) {
        $nodeId = $oMbqEtForumPost->postId->oriValue;
        $reputationApi = vB_Api::instanceInternal('reputation');
        $reputationApi->unvote($nodeId);
    }
    
}
