<?php

defined('MBQ_IN_IT') or exit;

MbqMain::$oClk->includeClass('MbqBaseRdEtForumPost');

/**
 * forum post read class
 */
Class MbqRdEtForumPost extends MbqBaseRdEtForumPost {

    public function __construct() {
    }

    public function makeProperty(&$oMbqEtForumPost, $pName, $mbqOpt = array()) {
        switch ($pName) {
            default:
                MbqError::alert('', __METHOD__ . ',line:' . __LINE__ . '.' . MBQ_ERR_INFO_UNKNOWN_PNAME . ':' . $pName . '.');
                break;
        }
    }

    /**
     * get forum post position
     *
     * @param  Object  $oMbqEtForumPost
     *
     * @return  Integer
     */
    public function exttGetForumPostPosition($oMbqEtForumPost) {
        //ref $this->getObjsMbqEtForumPost(),case = 'topic'
        $search['channel'] = $oMbqEtForumPost->topicId->oriValue;
    	$search['view'] = vB_Api_Search::FILTER_VIEW_CONVERSATION_THREAD;
    	$search['depth'] = 1;
        $search['include_starter'] = true;
        $search['sort']['created'] = 'asc';
        $search['nolimit'] = 1;
    	try {
        	$result = vB_Api::instanceInternal('search')->getInitialResults($search, 1000000, 1, true); //get all the posts to use
        	if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
            	$arrPostRecord = $result['results'];
            } else {
            	$arrPostRecord = array();
            }
        }
        catch (Exception $e) {
        	$arrPostRecord = array();
        }
        $ret = 1;
        foreach ($arrPostRecord as $postRecord) {
            if ($postRecord['content']['nodeid'] == $oMbqEtForumPost->postId->oriValue) {
                return $ret;
            }
            $ret ++;
        }
        //not found
        return 1;
    }

    /**
     * get forum post objs
     *
     * @param  Mixed  $var
     * @param  Array  $mbqOpt
     * $mbqOpt['case'] = 'byTopic' means get data by forum topic obj.$var is the forum topic obj.
     * $mbqOpt['case'] = 'byPostIds' means get data by post ids.$var is the ids.
     * $mbqOpt['case'] = 'byArrPostRecord' means get data by byArrPostRecord.$var is the arrPostRecord.
     * $mbqOpt['case'] = 'byReplyUser' means get data by reply user.$var is the MbqEtUser obj.
     * @return  Mixed
     */
    public function getObjsMbqEtForumPost($var, $mbqOpt) {
        if ($mbqOpt['case'] == 'byTopic') {
            $oMbqEtForumPost = $var;
            if ($mbqOpt['oMbqDataPage']) {
                $oMbqDataPage = $mbqOpt['oMbqDataPage'];
            	$search['channel'] = $oMbqEtForumPost->topicId->oriValue;
            	//$search['contenttypeid'] = vB_Api::instanceInternal('contenttype')->fetchContentTypeIdFromClass('Text');
            	$search['view'] = vB_Api_Search::FILTER_VIEW_CONVERSATION_THREAD;
            	//$search['depth'] = EXTTMBQ_NO_LIMIT_DEPTH;
            	$search['depth'] = 1;
	            $search['include_starter'] = true;
	            //$search['sort']['publishdate'] = 'asc';
	            $search['sort']['created'] = 'asc';
                $search['nolimit'] = 1;
            	try {
                	$result = vB_Api::instanceInternal('search')->getInitialResults($search, $oMbqDataPage->numPerPage, $oMbqDataPage->curPage, true);
                	if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                    	$oMbqDataPage->totalNum = $result['totalRecords'];
                    	$arrPostRecord = $result['results'];
                    } else {
                    	$oMbqDataPage->totalNum = 0;
                    	$arrPostRecord = array();
                    }
                }
                catch (Exception $e) {
                	$oMbqDataPage->totalNum = 0;
                	$arrPostRecord = array();
                }
                $mbqOpt['case'] = 'byArrPostRecord';
                return $this->getObjsMbqEtForumPost($arrPostRecord, $mbqOpt);
                /*$nodeIds = array();
                foreach ($arrPostRecord as $postRecord) {
                $nodeIds[] = $postRecord['nodeid'];
                }
                /* common begin */
                $mbqOpt['case'] = 'byPostIds';
                $mbqOpt['oMbqDataPage'] = $oMbqDataPage;
                return $this->getObjsMbqEtForumPost($nodeIds, $mbqOpt);
                /* common end */
            }
        } elseif ($mbqOpt['case'] == 'byPostIds') {
        	try {
            	$result = vB_Api::instanceInternal('node')->getFullContentforNodes($var);
            	if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                	$arrPostRecord = $result;
                } else {
                	$arrPostRecord = array();
                }
            }
            catch (Exception $e) {
            	$arrPostRecord = array();
            }
            /* common begin */
            $mbqOpt['case'] = 'byArrPostRecord';
            return $this->getObjsMbqEtForumPost($arrPostRecord, $mbqOpt);
            /* common end */
        } elseif ($mbqOpt['case'] == 'byReplyUser') {
            if ($mbqOpt['oMbqDataPage']) {
                $oMbqDataPage = $mbqOpt['oMbqDataPage'];
                $top = vB_Api::instance('content_channel')->fetchTopLevelChannelIds();
                $search['channel'] = $top['forum'];
            	$search['authorid'] = $var->userId->oriValue;
            	$search['contenttypeid'] = vB_Api::instanceInternal('contenttype')->fetchContentTypeIdFromClass('Text');
            	$search['depth'] = EXTTMBQ_NO_LIMIT_DEPTH;
	            $search['sort']['publishdate'] = 'desc';
            	try {
                	$result = vB_Api::instanceInternal('search')->getInitialResults($search, $oMbqDataPage->numPerPage, $oMbqDataPage->curPage, true);
                	if (!MbqMain::$oMbqAppEnv->exttHasErrors($result)) {
                    	$oMbqDataPage->totalNum = $result['totalRecords'];
                    	$arrPostRecord = $result['results'];
                    } else {
                    	$oMbqDataPage->totalNum = 0;
                    	$arrPostRecord = array();
                    }
                }
                catch (Exception $e) {
                	$oMbqDataPage->totalNum = 0;
                	$arrPostRecord = array();
                }
                $nodeIds = array();
                foreach ($arrPostRecord as $postRecord) {
                    $nodeIds[] = $postRecord['nodeid'];
                }
                /* common begin */
                $mbqOpt['case'] = 'byPostIds';
                $mbqOpt['oMbqDataPage'] = $oMbqDataPage;
                return $this->getObjsMbqEtForumPost($nodeIds, $mbqOpt);
                /* common end */
            }
        } elseif ($mbqOpt['case'] == 'byArrPostRecord') {
            $arrPostRecord = $var;
            /* common begin */
            $objsMbqEtForumPost = array();
            $authorUserIds = array();
            $topicIds = array();
            foreach ($arrPostRecord as $postRecord) {
                $objsMbqEtForumPost[] = $this->initOMbqEtForumPost($postRecord, array('case' => 'postRecord'));
            }
            foreach ($objsMbqEtForumPost as $oMbqEtForumPost) {
                $authorUserIds[$oMbqEtForumPost->postAuthorId->oriValue] = $oMbqEtForumPost->postAuthorId->oriValue;
                $topicIds[$oMbqEtForumPost->topicId->oriValue] = $oMbqEtForumPost->topicId->oriValue;
            }
            /* load oMbqEtForumTopic property and oMbqEtForum property */
            $oMbqRdEtForumTopic = MbqMain::$oClk->newObj('MbqRdEtForumTopic');
            $objsMbqEtFroumTopic = $oMbqRdEtForumTopic->getObjsMbqEtForumTopic($topicIds, array('case' => 'byTopicIds'));
            foreach ($objsMbqEtFroumTopic as $oNewMbqEtFroumTopic) {
                foreach ($objsMbqEtForumPost as &$oMbqEtForumPost) {
                    if ($oNewMbqEtFroumTopic->topicId->oriValue == $oMbqEtForumPost->topicId->oriValue) {
                        $oMbqEtForumPost->oMbqEtForumTopic = $oNewMbqEtFroumTopic;
                        if ($oMbqEtForumPost->oMbqEtForumTopic->oMbqEtForum) {
                            $oMbqEtForumPost->oMbqEtForum = $oMbqEtForumPost->oMbqEtForumTopic->oMbqEtForum;
                            $oMbqEtForumPost->forumId->setOriValue($oMbqEtForumPost->oMbqEtForum->forumId->oriValue);
                        }
                    }
                }
            }
            /* load post author */
            $oMbqRdEtUser = MbqMain::$oClk->newObj('MbqRdEtUser');
            $objsAuthorMbqEtUser = $oMbqRdEtUser->getObjsMbqEtUser($authorUserIds, array('case' => 'byUserIds'));
            $postIds = array();
            foreach ($objsMbqEtForumPost as &$oMbqEtForumPost) {
                $postIds[] = $oMbqEtForumPost->postId->oriValue;
                foreach ($objsAuthorMbqEtUser as $oAuthorMbqEtUser) {
                    if ($oMbqEtForumPost->postAuthorId->oriValue == $oAuthorMbqEtUser->userId->oriValue) {
                        $oMbqEtForumPost->oAuthorMbqEtUser = $oAuthorMbqEtUser;
                        if ($oMbqEtForumPost->oAuthorMbqEtUser->isOnline->hasSetOriValue()) {
                            $oMbqEtForumPost->isOnline->setOriValue($oMbqEtForumPost->oAuthorMbqEtUser->isOnline->oriValue ? MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumPost.isOnline.range.yes') : MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumPost.isOnline.range.no'));
                        }
                        if ($oMbqEtForumPost->oAuthorMbqEtUser->iconUrl->hasSetOriValue()) {
                            $oMbqEtForumPost->authorIconUrl->setOriValue($oMbqEtForumPost->oAuthorMbqEtUser->iconUrl->oriValue);
                        }
                        break;
                    }
                }
            }
            /* load attachment */
            $oMbqRdEtAtt =  MbqMain::$oClk->newObj('MbqRdEtAtt');
            $objsMbqEtAtt = $oMbqRdEtAtt->getObjsMbqEtAtt($postIds, array('case' => 'byForumPostIds'));
            foreach ($objsMbqEtAtt as $oMbqEtAtt) {
                foreach ($objsMbqEtForumPost as &$oMbqEtForumPost) {
                    if ($oMbqEtForumPost->postId->oriValue == $oMbqEtAtt->postId->oriValue) {
                        $oMbqEtForumPost->objsMbqEtAtt[] = $oMbqEtAtt;
                    }
                }
            }
            /* load objsNotInContentMbqEtAtt */
            foreach ($objsMbqEtForumPost as &$oMbqEtForumPost) {
                $filedataids = MbqMain::$oMbqCm->getAttIdsFromContent($oMbqEtForumPost->postContent->oriValue);
                foreach ($oMbqEtForumPost->objsMbqEtAtt as $oMbqEtAtt) {
                    if (!in_array($oMbqEtAtt->mbqBind['attRecord']['nodeid'], $filedataids)) {
                        $oMbqEtForumPost->objsNotInContentMbqEtAtt[] = $oMbqEtAtt;
                        if(($key = array_search($oMbqEtAtt, $oMbqEtForumPost->objsMbqEtAtt)) !== false) {
                            unset($oMbqEtForumPost->objsMbqEtAtt[$key]);
                        }
                    }
                }
            }
            /* load objsMbqEtThank property and make related properties/flags */
            //
            /* make other properties */
            $oMbqAclEtForumPost = MbqMain::$oClk->newObj('MbqAclEtForumPost');
            foreach ($objsMbqEtForumPost as &$oMbqEtForumPost) {
                if ($oMbqAclEtForumPost->canAclSaveRawPost($oMbqEtForumPost)) {
                    $oMbqEtForumPost->canEdit->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumPost.canEdit.range.yes'));
                } else {
                    $oMbqEtForumPost->canEdit->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumPost.canEdit.range.no'));
                }
            }
            /* common end */
            if (isset($mbqOpt['oMbqDataPage'])) {
                $oMbqDataPage = $mbqOpt['oMbqDataPage'];
                $oMbqDataPage->datas = $objsMbqEtForumPost;
                return $oMbqDataPage;
            } else {
                return $objsMbqEtForumPost;
            }
        }
        MbqError::alert('', __METHOD__ . ',line:' . __LINE__ . '.' . MBQ_ERR_INFO_UNKNOWN_CASE);
    }

    /**
     * init one forum post by condition
     *
     * @param  Mixed  $var
     * @param  Array  $mbqOpt
     * $mbqOpt['case'] = 'postRecord' means init forum post by postRecord
     * $mbqOpt['case'] = 'byPostId' means init forum post by post id
     * @return  Mixed
     */
    public function initOMbqEtForumPost($var, $mbqOpt) {
        if ($mbqOpt['case'] == 'postRecord') {
            $nodeid = $var['content']['nodeid'];
            $raw_text = str_replace("\n", "<br/>", $var['content']['rawtext']);
            $raw_text = str_replace("\r", "<br/>", $raw_text);
            $result = vB_Api::instanceInternal('content_text')->getDataForParse(array($nodeid));
            //the $result[$nodeid]['bbcodeoptions'] caused guest can see limited content for example:image,so removed it
            //$macro = vB5_Template_NodeText::instance()->register($nodeid);

            //$macro = vB5_Template_NodeText::instance()->register($nodeid, $result[$nodeid]['bbcodeoptions']);
            //vB5_Template_NodeText::instance()->replacePlaceholders($macro);

            //$macro .= $this->getDataLink($var);

            $oMbqEtForumPost = MbqMain::$oClk->newObj('MbqEtForumPost');
            $oMbqEtForumPost->postId->setOriValue($var['content']['nodeid']);
            $oMbqEtForumPost->forumId->setOriValue($var['content']['channelid']);
            $oMbqEtForumPost->topicId->setOriValue($var['content']['starter']);
            $oMbqEtForumPost->postTitle->setOriValue($var['content']['title']);
            $oMbqEtForumPost->postAuthorId->setOriValue($var['content']['userid']);
            $oMbqEtForumPost->postTime->setOriValue($var['content']['created']);
            $oMbqEtForumPost->mbqBind['postRecord'] = $var;
            $oMbqEtForumPost->mbqBind['bbcodeoptions'] = $result[$nodeid]['bbcodeoptions'];
            if(MbqCm::checkIfUserIsIgnored($var['content']['userid']))
            {
                $raw_text = '[spoiler]'. $raw_text. '[/spoiler]';
            }
            $oMbqEtForumPost->postContent->setOriValue($var['content']['rawtext']);
            $oMbqEtForumPost->postContent->setAppDisplayValue($raw_text);
            $oMbqEtForumPost->postContent->setTmlDisplayValue(htmlspecialchars_decode($this->processContentForDisplay($raw_text, true, $oMbqEtForumPost)));
            $oMbqEtForumPost->postContent->setTmlDisplayValueNoHtml(htmlspecialchars_decode($this->processContentForDisplay($raw_text, false, $oMbqEtForumPost)));
            $oMbqEtForumPost->shortContent->setOriValue(MbqMain::$oMbqCm->getShortContent($oMbqEtForumPost->postContent->tmlDisplayValue));

            $oMbqEtForumPost->canLike->setOriValue($var['content']['permissions']['canuserep'] && (!isset(MbqMain::$oCurMbqEtUser) || $var['content']['userid'] != MbqMain::$oCurMbqEtUser->userId->oriValue));
            $oMbqEtForumPost->isLiked->setOriValue($var['content']['nodeVoted']);

            //get like info
            $oMbqRdEtLike = MbqMain::$oClk->newObj('MbqRdEtLike');
            $oMbqEtForumPost->likeCount->setOriValue($oMbqRdEtLike->getLikeCount($var['content']));
            $objsMbqEtLike = $oMbqRdEtLike->getObjsMbqEtLike($var['content'], array('case' => 'all'));
            $oMbqEtForumPost->objsMbqEtLike = $objsMbqEtLike;


            /* add info theard */

            if (!$var['showpublished'] && $var['deleteuserid']) {
                $oMbqEtForumPost->isDeleted->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumTopic.isDeleted.range.yes'));
            } else {
                $oMbqEtForumPost->isDeleted->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumTopic.isDeleted.range.no'));
            }

            if ($var['approved'] == 1) {
                $oMbqEtForumPost->isApproved->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumTopic.isApproved.range.yes'));
            } else {
                $oMbqEtForumPost->isApproved->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumTopic.isApproved.range.no'));
            }

            if ($var['content']['approved']) {
                $oMbqEtForumPost->state->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumPost.state.range.postOk'));
            } else {
                $oMbqEtForumPost->state->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumPost.state.range.postOkNeedModeration'));
            }


            if (MbqMain::hasLogin()) {

                /* add moderation */
                $oCurUser = (object) MbqMain::$oMbqAppEnv->currentUserInfo;
                $moderatorperms = (object) $var['content']['moderatorperms'];


                if ($oMbqEtForumPost->isDeleted->oriValue) {
                    if (isset($moderatorperms->candeleteposts) && $moderatorperms->candeleteposts) {
                        $oMbqEtForumPost->canDelete->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumTopic.canDelete.range.yes'));
                    } else {
                        $oMbqEtForumPost->canDelete->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumTopic.canDelete.range.no'));
                    }
                } else {
                    if (isset($moderatorperms->candeleteposts) && $moderatorperms->candeleteposts) {
                        $oMbqEtForumPost->canDelete->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumTopic.canDelete.range.yes'));
                    } else {
                        $oMbqEtForumPost->canDelete->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumTopic.canDelete.range.no'));
                    }
                }


                if (isset($moderatorperms->canmoderateposts) && $moderatorperms->canmoderateposts) {
                    $oMbqEtForumPost->canApprove->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumTopic.canApprove.range.yes'));
                } else {
                    $oMbqEtForumPost->canApprove->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumTopic.canApprove.range.no'));
                }
                if (isset($moderatorperms->canmassmove) && $moderatorperms->canmassmove) {
                    $oMbqEtForumPost->canMove->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumTopic.canClose.range.yes'));
                } else {
                    $oMbqEtForumPost->canMove->setOriValue(MbqBaseFdt::getFdt('MbqFdtForum.MbqEtForumTopic.canClose.range.no'));
                }

                /* end moderation */

            }



            return $oMbqEtForumPost;
        } elseif ($mbqOpt['case'] == 'byPostId') {
            $objsMbqEtForumPost = $this->getObjsMbqEtForumPost(array($var), array('case' => 'byPostIds'));
            if ($objsMbqEtForumPost) {
                $oMbqEtForumPost = $objsMbqEtForumPost[0];
                if(isset($mbqOpt['requirePosition']) && $mbqOpt['requirePosition'])
                {
                    $position =  $this->exttGetForumPostPosition($oMbqEtForumPost);
                    $oMbqEtForumPost->position->setOriValue($position);
                }
                return $oMbqEtForumPost;
            } else {
                return false;
            }
        }
        elseif ($mbqOpt['case'] == 'byPostIds') {
            if(!is_array($var))
            {
                $var = array($var);
            }
            $objsMbqEtForumPost = $this->getObjsMbqEtForumPost($var, array('case' => 'byPostIds'));
            if ($objsMbqEtForumPost) {
                return $objsMbqEtForumPost;
            } else {
                return false;
            }
        }
        MbqError::alert('', __METHOD__ . ',line:' . __LINE__ . '.' . MBQ_ERR_INFO_UNKNOWN_CASE);
    }

    public function getDataLink($node){
        $link = '<br />';
        $contenttype = vB_Types::instance()->getContentTypes();
        foreach ($contenttype as $type){
            if(isset($node['contenttypeid']) and $node['contenttypeid']==$type['id'] ) $link = $this->get($type['class'], $node);
        }
        return $link;
    }

    public function get($class, $node){
        $fn = "get$class";
        $data = '';
        $classes = array('Photo','Link','Video');
        if(in_array($class, $classes)){
            $data =  $this->$fn($node);
            $data .= '<br />'. $this->getText($node);
        }
        return $data ;
    }

    public function getPhoto($node){
        return $img = '[img]' . MbqMain::$oMbqAppEnv->rootUrl.'/filedata/fetch?photoid='.$node['link_nodeid'] . '[/img]';
    }

    public function getPicture($node){
        return $img = '[img]' . MbqMain::$oMbqAppEnv->rootUrl.'/filedata/fetch?linkid='.$node['link_nodeid'] . '[/img]';
    }

    function processContentAttachFile($post, $node){
        $attach = $node['content']['attachments'];
        if($attach){
            preg_match_all('/\[img\].*?\/fetch\?id=([0-9]{1,10}).*?\[\/img\]/i', $post, $math);
            if($math[1])
            {
                foreach ($attach as $file){
                    foreach ($math[1] as $k => $fid){
                        if($file['filedataid'] == $fid){
                            if(isset($file['resize_dateline']))
                            {
                                $dateline = $file['resize_dateline'];
                            }
                            else
                            {
                                $dateline = $file['dateline'];
                            }
                            $post = str_replace($math[0][$k],'[IMG]'.MbqMain::$oMbqAppEnv->rootUrl.'/filedata/fetch?id='.$file['nodeid'].'&d=' . $dateline . '[/IMG]',$post);
//                            $post = preg_replace("/\[img\].*\/fetch\?id=$fid.*\[\/img\]/i", '[IMG]'.MbqMain::$oMbqAppEnv->rootUrl.'/filedata/fetch?id='.$file['nodeid'].'&d=' . $dateline . '[/IMG]', $post);
                        }
                    }
                }
            }
            else
            {
                preg_match_all('/\[url.*?\/fetch\?id=([0-9]{1,10}).*?\[\/url\]/i', $post, $math);
                if($math[1])
                {
                    foreach ($attach as $file){
                        foreach ($math[1] as $k => $fid){
                            if($file['nodeid'] == $fid){
                                if(isset($file['resize_dateline']))
                                {
                                    $dateline = $file['resize_dateline'];
                                }
                                else
                                {
                                    $dateline = $file['dateline'];
                                }
                                $post = str_replace($math[0][$k],'[url='.MbqMain::$oMbqAppEnv->rootUrl.'/filedata/fetch?id='.$file['nodeid'].'&d=' . $dateline . ']' . $file['filename'] . '[/url]',$post);
//                                $post = preg_replace("/\[url.*\/fetch\?id=$fid.*\[\/url\]/i", '[url='.MbqMain::$oMbqAppEnv->rootUrl.'/filedata/fetch?id='.$file['nodeid'].'&d=' . $dateline . ']' . $file['filename'] . '[/url]', $post);
                            }
                        }
                    }
                }
                else
                {
                    preg_match_all('/\[ATTACH=JSON\]([^\[]*?)\[\/ATTACH\]/i', $post, $math);
                    if($math[1])
                    {
                        foreach ($attach as $file){
                            foreach ($math[1] as $k =>  $fid)
                            {
                                $attachInfo = json_decode($fid, true);
                                if(isset($attachInfo)) {
                                    if ($file['nodeid'] == $attachInfo['data-attachmentid']) {
                                        if (isset($file['resize_dateline'])) {
                                            $dateline = $file['resize_dateline'];
                                        } else {
                                            $dateline = $file['dateline'];
                                        }
                                        $post = str_replace($math[0][$k], '[img]' . MbqMain::$oMbqAppEnv->rootUrl . '/filedata/fetch?id=' . $file['nodeid'] . '&d=' . $dateline . '[/img]', $post);
//                                        $post = str_replace("[ATTACH=JSON]". $fid . "[/ATTACH]", '[img]'.MbqMain::$oMbqAppEnv->rootUrl.'/filedata/fetch?id='.$file['nodeid'].'&d=' . $dateline . '[/img]', $post);     }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return $post;
    }

    public function getVideo($node){
        $providers = array(
            'hulu' => 'http://www.hulu.com/embed/videocode',
            'youtube' => 'http://www.youtube.com/v/kXYiU_JCYtU?fs=1&hd=0&rel=1&cc_load_policy=1',
            'youtube_share' => 'http://www.youtube.com/embed/videocode?wmode={vb:raw vboptions.player_wmode}&autoplay=1',
            'vimeo' => 'http://vimeo.com/moogaloop.swf?clip_id=videocode',
            'dailymotion' => 'http://www.dailymotion.com/swf/videocode',
            'metacafe' => 'http://www.metacafe.com/fplayer/videocode.swf',
            'google' => 'http://video.google.com/googleplayer.swf?docid=videocode',
            'facebook' => 'http://www.facebook.com/v/videocode',
        );
        $items = array();
        foreach ($node['items'] as $video){
            $url = str_replace('videocode', $video['code'], $providers[$video['provider']]);
            $items[] = '[url=' . $url . ']' . $url . '[/url]';
        }
        return implode('<br />', $items);
    }

    public function getLink($node){
        if(isset($node['link_nodeid'])) return $img = '[img]' . MbqMain::$oMbqAppEnv->rootUrl.'/filedata/fetch?linkid='.$node['link_nodeid'] . '[/img]';
        return $link = '[url=' . $node['url'] . ']' . $node['url'] . '[/url]';
    }

    public function getText($node){
        return $node['meta'];
    }

    /**
     * process content for display in mobile app
     *
     * @params  String  $content
     * @params  Boolean  $returnHtml
     * @params  Object  $obj($oMbqEtForumPost/$oMbqEtPcMsg)
     * @return  String
     */
    public function processContentForDisplay($content, $returnHtml, $obj) {
        /*
        support bbcode:url/img/quote
        support html:br/i/b/u/font+color(red/blue)
        <strong> -> <b>
        attention input param:return_html
        attention output param:post_content
         */
        $post = $content;

        //add custom
        $TT_bbcodereplace = '';
        if(class_exists('MbqMain') && MbqMain::$Cache->Exists('Config','tapatalk_custom_replace'))
        {
            $TT_bbcodereplace = MbqMain::$Cache->Get('Config','tapatalk_custom_replace');
        }
        else
        {
            $options = vB::getDatastore()->getValue('publicoptions');
            if(isset($options['tapatalk_custom_replacement']))
            {
                $TT_bbcodereplace = $options['tapatalk_custom_replacement'];
                if(class_exists('MbqMain'))
                {
                    MbqMain::$Cache->Set('Config','tapatalk_custom_replace', $TT_bbcodereplace);
                }
            }
        }
        if(!empty($TT_bbcodereplace))
        {
            $replace_arr = explode("\n", $TT_bbcodereplace);
            foreach ($replace_arr as $replace)
            {
                preg_match('/^\s*(\'|")((\#|\/|\!).+\3[ismexuADUX]*?)\1\s*,\s*(\'|")(.*?)\4\s*$/', $replace,$matches);
                if(count($matches) == 6)
                {
                    $temp_str = $post;
                    $post = @preg_replace($matches[2], $matches[5], $post);
                    if(empty($post))
                    {
                        $post = $temp_str;
                    }
                }
            }
        }

        if ($returnHtml) {
            //MbqCm::writeLog($content."\n\n\n\n--------------------------------------------------------\n\n\n\n", true);
            if ($obj->mbqBind['bbcodeoptions']['allowsmilies']) {
                /* directly display smillies picture before app implement it for vb5
            	$post = preg_replace('/<img [^>]*?src="[^>]*?\/core\/images\/smilies\/biggrin.png"[^>]*?\/>/i', ':D', $post);
            	$post = preg_replace('/<img [^>]*?src="[^>]*?\/core\/images\/smilies\/frown.png"[^>]*?\/>/i', ':(', $post);
            	$post = preg_replace('/<img [^>]*?src="[^>]*?\/core\/images\/smilies\/mad.png"[^>]*?\/>/i', ':mad:', $post);
            	$post = preg_replace('/<img [^>]*?src="[^>]*?\/core\/images\/smilies\/tongue.png"[^>]*?\/>/i', ':p', $post);
            	$post = preg_replace('/<img [^>]*?src="[^>]*?\/core\/images\/smilies\/redface.png"[^>]*?\/>/i', ':o', $post);
            	$post = preg_replace('/<img [^>]*?src="[^>]*?\/core\/images\/smilies\/confused.png"[^>]*?\/>/i', ':confused:', $post);
            	$post = preg_replace('/<img [^>]*?src="[^>]*?\/core\/images\/smilies\/wink.png"[^>]*?\/>/i', ';)', $post);
            	$post = preg_replace('/<img [^>]*?src="[^>]*?\/core\/images\/smilies\/smile.png"[^>]*?\/>/i', ':)', $post);
            	$post = preg_replace('/<img [^>]*?src="[^>]*?\/core\/images\/smilies\/rolleyes.png"[^>]*?\/>/i', ':rolleyes:', $post);
            	$post = preg_replace('/<img [^>]*?src="[^>]*?\/core\/images\/smilies\/cool.png"[^>]*?\/>/i', ':cool:', $post);
            	$post = preg_replace('/<img [^>]*?src="[^>]*?\/core\/images\/smilies\/eek.png"[^>]*?\/>/i', ':eek:', $post);
                 */
            } else {
            }


            if ($obj->mbqBind['bbcodeoptions']['allowbbcode']) {

                $post = preg_replace('/<div align="(right|left|center)">(.*?)<\/div>/i', '<font align="$1">$2</font>', $post);
    	        $post = preg_replace('/<div class="bbcode_container">.*?<div class="bbcode_quote">.*?<div class="quote_container">.*?<div class="bbcode_quote_container vb-icon vb-icon-quote-large"><\/div>.*?<div class="bbcode_postedby">.*?<strong>(.*?)<\/strong>.*?<\/div>.*?<div class="message">(.*?)<\/div>.*?<\/div>.*?<\/div>.*?<\/div>/is', '[quote name=$1]$2[/quote]', $post);    //quote no quoted content
    	        $post = preg_replace('/<div class="bbcode_container">.*?<div class="bbcode_quote">.*?<div class="quote_container">.*?<div class="bbcode_quote_container vb-icon vb-icon-quote-large"><\/div>.*?<div class="bbcode_postedby">.*?<strong>(.*?)<\/strong>.*?<\/div>.*?<div class="message"><!-- ##.*?## -->(.*?)<\/div>.*?<\/div>.*?<\/div>.*?<\/div>/is', '[quote name=$1]$2[/quote]', $post);    //quote another quoted content
    	        $post = preg_replace('/<div class="bbcode_container">.*?<div class="bbcode_quote">.*?<div class="quote_container">.*?<div class="bbcode_quote_container vb-icon vb-icon-quote-large"><\/div>(.*?)<\/div>.*?<\/div>.*?<\/div>/is', '[quote]$1[/quote]', $post);    //simple quote,for example:[quote]anything[/quote]
    	        $post = preg_replace_callback('/<font color=\"(\#.*?)\">(.*?)<\/font>/is', function($matches) {return MbqMain::$oMbqCm->mbColorConvert($matches[1], $matches[2]);}, $post);
            	$post = str_ireplace('<strong>', '<b>', $post);
            	$post = str_ireplace('</strong>', '</b>', $post);
    	        $post = preg_replace('/<img .*?src="(.*?)" .*?\/>/i', '[img]$1[/img]', $post);
    	        $post = preg_replace('/<a .*?href="(.*?)".*?>(.*?)<\/a>/i', '[url=$1]$2[/url]', $post);
                $post = preg_replace('/<a .*?href="mailto:(.*?)".*?>(.*?)<\/a>/i', '[url=$1]$2[/url]', $post);
                $post = preg_replace('/mailto:/i', '', $post);
                $post = preg_replace('/<a.*?href="(.*?)".*?\s+>\s+.*?\s+(<img[^>]+src\s*=\s*"(.*?)"[^>].*?\s+\/?\>)?\s+.*\s+.*\s+<\/a>/i', '[url=$1]$1[/url]', $post);
                $post = preg_replace('/\[QUOTE=([^;]*);(\w+)]/is', '[quote name="$1" userid=$2]', $post);    //simple quote,for example:[quote]anything[/quote]
                $post = preg_replace('/\[\/QUOTE]/is', '[/quote]', $post);    //simple quote,for example:[quote]anything[/quote]


                //preg_match ("/<img[^>]+src\s*=\s*[\"']\/?([^\"']+)[\"'][^>]*\>/", $msg, $m);
                //preg_match('/<a .*?href="(.*?)".*?\s+>\s+.*?\s+<img[^>]+src\s*=\s*"(.*?)"[^>]*\>.*?<\/a>/i',$post, $x );

    	        $post = preg_replace('/<div class="bbcode_container">[^<]*?<div class="bbcode_description">PHP Code\:<\/div>[^<]*?<div class="bbcode_code"[^>]*?><code><code>(.*?)<\/code><\/code><\/div>[^<]*?<\/div>/is', 'PHP Code:[quote]$1[/quote]', $post);    //php
    	        $post = preg_replace('/<div class="bbcode_container">[^<]*?<div class="bbcode_description">Code\:<\/div>[^<]*?<pre class="bbcode_code"[^>]*?>(.*?)<\/pre>[^<]*?<\/div>/is', 'Code:[quote]$1[/quote]', $post);    //code
    	        $post = preg_replace('/<div class="bbcode_container">[^<]*?<div class="bbcode_description">HTML Code\:<\/div>[^<]*?<pre class="bbcode_code"[^>]*?>(.*?)<\/pre>[^<]*?<\/div>/is', 'HTML Code:[quote]$1[/quote]', $post);    //html
    	        //remove Attached Files html code

    	        $post = preg_replace('/<div class="attachment-list">[^<]*?Attached Files[^<]*?<ul>.*?<\/ul>[^<]*?<\/div>/is', '', $post);
    	        $post = preg_replace('/<div class="b-post-attachments">[^<]*?Attached Files[^<]*?<ul>.*?<\/ul>[^<]*?<\/div>/is', '', $post);
                $post = preg_replace('/<object .*?>.*?<embed src="(.*?)".*?\><\/object>/is', '[url=$1]$1[/url]', $post); /* for youtube content etc. */
                $post = str_ireplace('<hr />', '<br />____________________________________<br />', $post);

                $post = str_ireplace('<li>', "\t\t<li>", $post);

                $post = str_ireplace('</li>', "</li><br />", $post);
                $post = str_ireplace('</tr>', '</tr><br />', $post);
                $post = str_ireplace('</td>', "</td>\t\t", $post);
    	        $post = str_ireplace('</div>', '</div><br />', $post);
    	        $post = str_ireplace('&nbsp;', ' ', $post);

    	      //  $post = strip_tags($post, '<br><i><b><u><font>'); it removes <3
                $post = str_ireplace('[b]', '<b>', $post);
				$post = str_ireplace('[/b]', '</b>', $post);
				$post = str_ireplace('[i]', '<i>', $post);
				$post = str_ireplace('[/i]', '</i>', $post);
			    $re = "/\\[size=[^\\]]*]/i";
			    $post = preg_replace($re, '', $post);
				$re = "/\\[color=[^\\]]*]/i";
			    $post = preg_replace($re, '', $post);
				$re = "/\\[font=[^\\]]*]/i";
			    $post = preg_replace($re, '', $post);
				$post = str_ireplace('[/size]', '', $post);
				$post = str_ireplace('[/color]', '', $post);
				$post = str_ireplace('[/font]', '', $post);
				$post = str_ireplace('[center]', '', $post);
				$post = str_ireplace('[/center]', '', $post);
                $post = preg_replace_callback('/<font color=\"(\#.*?)\">(.*?)<\/font>/is', function($matches){ return MbqMain::$oMbqCm->mbColorConvert($matches[1], $matches[2]);}, $post);

                $post = preg_replace_callback('/\[IMG.*?\](\{[\s\S]+?\})\[\/IMG.*?\]/is',function($matches){
                    $img_url = @json_decode($matches[1],true);
                    if(isset($img_url['src'])){
                        return '[IMG]'.$img_url['src'].'[/IMG]';
                    } else {
                        return $matches[0];
                    }
                },$post);

            } else {
            }
        } else {
    	    $post = strip_tags($post);
        }

        if(isset($obj->mbqBind['postRecord']))
        {
	        $post = $this->processContentAttachFile($post, $obj->mbqBind['postRecord']);
        }
        else if(isset($obj->mbqBind['msgRecord']))
        {
            $post = $this->processContentAttachFile($post, $obj->mbqBind['msgRecord']);
        }
        $post = trim($post);
        //MbqCm::writeLog($post."\n\n\n\n--------------------------------------------------------\n\n\n\n", true);
    	return mobiquo_encode($post);
    }

    /**
     * return quote post content
     *
     * @param  Object  $oMbqEtForumPost
     * @return  String
     */
    public function getQuotePostContent($oMbqEtForumPost) {
        $oldContent = preg_replace('/\[quote.*?\].*?\[\/quote\]/is', '', $oMbqEtForumPost->postContent->oriValue);
        $ret = '[QUOTE='.$oMbqEtForumPost->oAuthorMbqEtUser->getDisplayName().';n'.$oMbqEtForumPost->postId->oriValue.']'.$oldContent.'[/QUOTE]';
        return $ret;
    }
    public function getRawPostContent($oMbqEtForumPost) {
        return $oMbqEtForumPost->postContent->oriValue;
    }
    public function getRawPostContentOriginal($oMbqEtForumPost) {
        return $oMbqEtForumPost->postContent->oriValue;
    }

    public function getUrl($oMbqEtForumPost)
    {
        $api = Api_InterfaceAbstract::instance();
        $node = $oMbqEtForumPost->mbqBind['postRecord'];
        $url = $api->callApi('route', 'getUrl', array($node['routeid'], array('nodeid' => $node['nodeid'], 'title' => $node['title'], 'urlident' => $node['urlident']), array('p'=>$oMbqEtForumPost->postId->oriValue)));
        $url = vB5_Template_Options::instance()->get('options.frontendurl') . $url;
        return (string)$url;
    }
}
