<?php

defined('MBQ_IN_IT') or exit;

MbqMain::$oClk->includeClass('MbqBaseRdCommon');

Class MbqRdCommon extends MbqBaseRdCommon {

    protected $options;

    public function __construct() {
        $this->options = vB::getDatastore()->getValue('options');
    }
    
    public function getApiKey()
    {
        $settings = $this->options;
        return isset($settings['tapatalk_api_key']) ? $settings['tapatalk_api_key'] : "";
    }
    public function getForumUrl()
    {
        $settings = $this->options;
        return $settings['frontendurl'];
    }
    public function getCheckSpam()
    {
        $settings = $this->options;
        return isset($settings['tapatalk_spam']) ? $settings['tapatalk_spam'] : true; 
    }
    public function getAppReg()
    {
        $settings = $this->options;
        return isset($settings['tapatalk_reg_type']) ? $settings['tapatalk_reg_type'] :  0; 
    }
    //auto approve registered user from tapatalk if relative option is setted to true
    public function getAutoApprove()
    {
        $settings = $this->options;
        return $settings['tapatalk_autoapproved']; 
    }
    //Sys reg setting
    public function allowRegistration()
    {
        $settings = $this->options;
        return $settings['allowregistration']; 
    }

    public function getPushSlug()
    {
        $oDb = vB::getDBAssertor()->getDBConnection();
        $results = $oDb->query_first(" SELECT * FROM " . TABLE_PREFIX . "tapatalk_status" );
        if ($results) {
            return unserialize($results['status_info']);
        }
        return 0;
    }
    public function getSmartbannerInfo()
    {
        return vB_Cache::instance(vB_Cache::CACHE_STD)->read('tapatalk_banner_data');
    }
    public function get_id_by_url($url)
    {
        $url = str_replace($this->getForumUrl() . '/','',$url);
        $route = Api_InterfaceAbstract::instance()->callApi('route', 'getRoute', array('pathInfo' => $url, 'queryString' => ''));
        //$bridge = Tapatalk_Bridge::getInstance();
        //$visitor = XenForo_Visitor::getInstance();

        //$url = str_ireplace("index.php?", "", $url);

        //$request = new Zend_Controller_Request_Http($url);
        //$request->setBasePath($bridge->_request->getBasePath());

        //$routeMatch = $bridge->getDependencies()->route($request);

        //switch($routeMatch->getControllerName()){
        //    case "XenForo_ControllerPublic_Thread":
        //        if($request->getParam('thread_id'))
        //        {
        //            $oMbqRdEtForumTopic = MbqMain::$oClk->newObj('MbqRdEtForumTopic');
        //            return $oMbqRdEtForumTopic->initOMbqEtForumTopic($request->getParam('thread_id'), array('case'=>'byTopicId'));
        //        }
        //        break;
        //    case "XenForo_ControllerPublic_Forum":
        //        if($request->getParam('node_id'))
        //        {
        //            $oMbqRdEtForum = MbqMain::$oClk->newObj('MbqRdEtForum');
        //            return $oMbqRdEtForum->initOMbqEtForum($request->getParam('node_id'), array('case'=>'byForumId'));
        //        }
        //        break;
        //    case "XenForo_ControllerPublic_Post":
        //        if($request->getParam('post_id'))
        //        {
        //            $oMbqRdEtForumPost = MbqMain::$oClk->newObj('MbqRdEtForumPost');
        //            return $oMbqRdEtForumPost->initOMbqEtForumPost($request->getParam('post_id'), array('case'=>'byPostId'));
        //        }
        //        break;
        //    case "XenForo_ControllerPublic_Conversation":
        //        if($request->getParam('conversation_id'))
        //        {
        //            $oMbqRdEtPc = MbqMain::$oClk->newObj('MbqRdEtPc');
        //            return $oMbqRdEtPc->initOMbqEtPc($request->getParam('conversation_id'), array('case'=>'byConvId'));
        //        }
        //        break;
        //}

        return "Cannot process url";
    }
}
