<?php
function get_usertype_by_grpid($grpid)
{
    if($grpid == 6)
        return 'admin';
    else if($grpid == 8){
        return 'banned';
    }
    else if($grpid == 5 || $grpid == 7)
        return 'mod';
    else if($grpid == 4)
        return 'unapproved';
    else if($grpid == 3)
        return 'inactive';
    else if($grpid == 2)
        return 'normal';
    return ' ';
}

function mobiquo_encode($str, $mode = '', $strip_tags = false)
{
    if ($strip_tags && empty($mode)) 
        $str = strip_tags($str);
    
    if (empty($str)) return $str;
    if (!class_exists('vB_Template_Runtime')) return $str;
    
    static $charset, $charset_89, $charset_AF, $charset_8F, $charset_chr, $charset_html, $support_mb, $charset_entity;
    
    if (!isset($charset))
    {
        $charset = trim(vB_String::getCharset());
        
        include_once(TT_ROOT.'/appExtt/charset.php');
        
        if (preg_match('/iso-?8859-?1/i', $charset))
        {
            $charset = 'Windows-1252';
            $charset_chr = $charset_8F;
        }
        if (preg_match('/iso-?8859-?(\d+)/i', $charset, $match_iso))
        {
            $charset = 'ISO-8859-' . $match_iso[1];
            $charset_chr = $charset_AF;
        }
        else if (preg_match('/windows-?125(\d)/i', $charset, $match_win))
        {
            $charset = 'Windows-125' . $match_win[1];
            $charset_chr = $charset_8F;
        }
        else
        {
            // x-sjis is not acceptable, but sjis do
            $charset = preg_replace('/^x-/i', '', $charset);
            $support_mb = function_exists('mb_convert_encoding') && @mb_convert_encoding('test', $charset, 'UTF-8');
        }
    }
    
    
    if (preg_match('/utf-?8/i', $charset))
    {
        $str = html_entity_decode($str, ENT_QUOTES, 'UTF-8');
    }
    else if (function_exists('mb_convert_encoding') && (strpos($charset, 'ISO-8859-') === 0 || strpos($charset, 'Windows-125') === 0) && isset($charset_html[$charset]))
    {
        if ($mode == 'to_local')
        {
            $str = @mb_convert_encoding($str, 'HTML-ENTITIES', 'UTF-8');
            $str = str_replace($charset_html[$charset], $charset_chr, $str);
        }
        else
        {
            if (strpos($charset, 'ISO-8859-') === 0)
            {
                // windows-1252 issue on ios
                $str = str_replace(array(chr(129), chr(141), chr(143), chr(144), chr(157)),
                                   array('&#129;', '&#141;', '&#143;', '&#144;', '&#157;'), $str);
            }
            
            $str = str_replace($charset_chr, $charset_html[$charset], $str);
            $str = @html_entity_decode($str, ENT_QUOTES, 'UTF-8');
        }
    }
    else if ($support_mb)
    {
        if ($mode == 'to_local')
        {
            $str = @mb_convert_encoding($str, 'HTML-ENTITIES', 'UTF-8');
            $str = @mb_convert_encoding($str, $charset, 'UTF-8');
        }
        else
        {
            $str = @mb_convert_encoding($str, 'UTF-8', $charset);
            $str = @html_entity_decode($str, ENT_QUOTES, 'UTF-8');
        }
    }
    else if (function_exists('iconv') && @iconv($charset, 'UTF-8', 'test-str'))
    {
        if ($mode == 'to_local')
        {
/*
            $str = @htmlentities($str, ENT_NOQUOTES | ENT_IGNORE, 'UTF-8');
            if(!isset($special_chars))
                include_once(CWD1.'/include/charset.php');
            if(isset($special_chars))
                foreach($special_chars as $find => $replace)
                    $str = str_replace($find, $replace, $str);
            $str = @iconv('UTF-8', $charset.'//IGNORE', $str);
            $str = str_replace($charset_html[$charset], $charset_chr, $str);
*/
            $str = utf8ToEntities($str);
            $str = @html_entity_decode($str, ENT_QUOTES, $charset);
        }
        else
        {
            $str = @iconv($charset, 'UTF-8//IGNORE', $str);
            $str = @html_entity_decode($str, ENT_QUOTES, 'UTF-8');
        }
    }
    else
    {
        if ($mode == 'to_local')
        {
            $str = @htmlentities($str, ENT_NOQUOTES | ENT_IGNORE, 'UTF-8');
            if($charset == 'Windows-1252') $str = utf8_decode($str);
            $str = @html_entity_decode($str, ENT_QUOTES, $charset);
        }
        else
        {
            $str = @html_entity_decode($str, ENT_QUOTES, 'UTF-8');
            if ($charset == 'Windows-1252') $str = utf8_encode($str);
        }
    }
    
    // html entity convert
    if ($mode == 'to_local')
    {
        $str = str_replace(array_keys($charset_entity), array_values($charset_entity), $str);
    }
    
    return remove_unknown_char($str);
}

function utf8ToEntities($string)
{ 
    /*
    * @see http://en.wikipedia.org/wiki/UTF-8#Description
    * @link http://community.invisionpower.com/tracker/issue-23681-possible-addition/
    */
    # Four-byte chars
    $string = preg_replace_callback( "/([\360-\364])([\200-\277])([\200-\277])([\200-\277])/", "callback_four_bytes_chars", $string );

    /* Three byte chars */
    $string = preg_replace_callback( "/([\340-\357])([\200-\277])([\200-\277])/", "callback_three_bytes_chars", $string ); 

    /* Two byte chars */
    $string = preg_replace_callback("/([\300-\337])([\200-\277])/", "callback_two_bytes_chars", $string); 

    return $string; 
}

function remove_unknown_char($str)
{
    for ($i = 1; $i < 32; $i++)
    {
        if (in_array($i, array(10, 13))) continue;
        $str = str_replace(chr($i), '', $str);
    }
    
    return $str;
}