<?php

class TwitterLogin_Controller_Page extends vB5_Frontend_Controller
{
	public function actionAuthCallback()
	{
		/*
			Upon a successful authentication, your callback_url would receive a request
			containing the oauth_token and oauth_verifier parameters. Your application
			should verify that the token matches the request token received in step 1.
		 */
		/*
			additionally our URL will have libid & userid (or guest=true if signing-in instead of linking)
			to help us find the token stored @ step 1.
			$urlSuffix =  "/twitterlogin/auth_callback?libid={$libid}&userid={$userid}";
		 */

		$frontendurl = vB5_Template_Options::instance()->get('options.frontendurl');
		$api = Api_InterfaceAbstract::instance();
		$callNamed = true; // pass named vars
		$vars = array(
			'libid' => $_REQUEST['libid'] ?? null,
			'oauth_token' => $_REQUEST['oauth_token'] ?? null,
			'oauth_verifier' => $_REQUEST['oauth_verifier'] ?? null,
			'nonce' => $_REQUEST['nonce'] ?? null,
			'hash' => $_REQUEST['hash'] ?? null,
		);
		/*
			Per testing, if user denies authorization for the app, the callback is passed the original
			parameters + a &denied={old token} parameter instead of the token & verifier params.
		 */
		if (isset($_REQUEST['denied']))
		{
			$vars['denied'] = $_REQUEST['denied'];
		}

		if (isset($_REQUEST['resume_url']))
		{
			$vars['resume_url'] = base64_decode($_REQUEST['resume_url'], true);
			// only allow internal redirects.
			$isSiteUrl = $api->callApi('TwitterLogin:ExternalLogin', 'isSiteUrl', [$vars['resume_url']]);
			if (!$isSiteUrl)
			{
				$vars['resume_url'] = null;
			}
		}

		if (!empty($_REQUEST['guest']) AND empty($_REQUEST['userid']))
		{
			/*
			Edge case: a user might hit this page again upon logging in if they, e.g. try to
			login via twitter, cancel instead of logging into twitter & approving, then try
			twitterlogin again and login/approve. In that case, we probably lost the return_to_url
			in the sessionauth.
			See if we preserved the URL via resume_url parameter. If not, we'll redirect them
			to the home page so they don't see an erroneous "You must authorize..." message again
			after logging in.
			Note that this flow does NOT check the nonce, as we're assuming they're stuck on a
			previous error page. However, any hijack effect is mitigated by the fact that we
			limit redirects to hosts allowed by the URL class.
			 */
			$currentUser = vB5_User::get('userid');
			if (!empty($currentUser))
			{
				$url = $vars['resume_url'] ?? $frontendurl;
				header('Location: ' . $url, true, 302);
				exit;
			}

			$check = $api->callApi('TwitterLogin:ExternalLogin', 'verifyAuthAndLogin', $vars, $callNamed);

			/*
			If twitter user did not link an account, & we could pull user info from twitter, 
			redirect to the registration page (VBV-19483).
			 */
			if (isset($check['error_redirect']))
			{
				// skipping the isSiteUrl check here because the API should not be returning a
				// none-site URL for this param.
				header('Location: ' . $check['error_redirect'], true, 302);
				return true;
			}

			if (isset($check['error']))
			{
				return $this->showErrorPage($check['error']);
			}
			else if (isset($check['errors']))
			{
				// todo: render error fully?
				return $this->showErrorPage($check['errors'][0]);
			}

			vB5_Auth::setLoginCookies($check['login'], 'external', true);

			$url = $vars['resume_url'] ?? $frontendurl;
			header('Location: ' . $url, true, 302);
			$this->sendAsJson(array('response' => $check));
			return true;
		}
		else if (!empty($_REQUEST['register']) AND empty($_REQUEST['userid']))
		{
			/*
				At this point, we have a sessionauth alive with verify params & return_to_url param that's pointing
				back to the register page.
				We should fetch some userinfo, save it back to the sessionauth, redirect back to the register page,
				and have the twitterlogin template hook on that register page pull data back from the sessionauth
				to prefill the registration form values.

				E.g. additiona_params:
				{"verify_token_nonce":"YUWHDXYGPIAJBUD74YFLG75AS3WAUHDM","return_to_url":"http:\/\/pluto.here\/cora\/register?urlpath=aHR0cDovL3BsdXRvLmhlcmUvY29yYS8%3D"}
			 */
			$check = $api->callApi('TwitterLogin:ExternalLogin', 'verifyAuthForvBRegistration', $vars, $callNamed);

			if (isset($check['error']))
			{
				return $this->showErrorPage($check['error']);
			}
			else if (isset($check['errors']))
			{
				// todo: render error fully?
				return $this->showErrorPage($check['errors'][0]);
			}

			if (!empty($check['resume_url']))
			{
				/*
					If successful, verifyAuthForvBRegistration() should append the twitterlogin_saved
					query param necessary for the registration form auto-fill via
					twitterlogin_registeruserbutton template to resume_url
				 */
				$url = $check['resume_url'];
			}
			else
			{
				// registration page
				$url = vB5_Template_Options::instance()->get('options.frontendurl') . "/register";
			}

			header('Location: ' . $url, true, 302);
			$this->sendAsJson(array('response' => $check));
			return true;
		}
		else
		{
			$check = $api->callApi('TwitterLogin:ExternalLogin', 'verifyAuthAndLinkUser', $vars, $callNamed);
		}

		if (!empty($check['error']))
		{
			return $this->showErrorPage($check['error']);
		}
		else if (!empty($check['success']))
		{
			// redirect to previous page.
			$url = $vars['resume_url'] ?? $frontendurl;
			header('Location: ' . $url, true, 302);
			exit;
		}
		else
		{
			return $this->showErrorPage("unknown_error");
		}

	}



	public function showErrorPage($message)
	{
		$page = array('noindex' => true, 'nofollow' => true);
		$templater = new vB5_Template('error_page');
		$templater->registerGlobal('page', $page);
		$templater->register('error', array('message' => $message));

		$output = vB5_ApplicationAbstract::getPreheader() . $templater->render();
		echo $output;
		exit; // don't show anything else.
	}
}
